package benchmarks;

import java.io.IOException;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;

import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.natives.NATText;

public class ProtostuffLib implements TestMethods {

	@Override
	public byte[] serialize(Object o) throws IOException {
		LinkedBuffer buffer =  LinkedBuffer.allocate(2048);
		Schema<Object> schema = (Schema<Object>) RuntimeSchema.getSchema(o.getClass());
		return GraphIOUtil.toByteArray(o, schema, buffer);
	}

	@Override
	public Object deserialize(byte[] b, Class c) throws IOException, ClassNotFoundException {	
		Object a = RuntimeSchema.getSchema(c).newMessage();
		GraphIOUtil.mergeFrom(b, a, RuntimeSchema.getSchema(c));
		return a;
	}

	@Override
	public Object copy(Object o) throws IOException, ClassNotFoundException {
		return deserialize(serialize(o), o.getClass());
	}


}
